<?php
include("db.php"); // Include your database connection
// Start the session
session_start();
$user_id = $_SESSION['user_id'] ?? null;
// Set content type to JSON
header('Content-Type: application/json');

// Check if the method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Read the raw POST data
    $rawData = file_get_contents('php://input');
    
    // Decode the JSON data
    $data = json_decode($rawData, true);

    // Check for JSON decoding errors
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid JSON input', 'error_detail' => json_last_error_msg()]);
        exit();
    }

    // Check for required fields
    if (!isset($data['Product_id'])) {
        echo json_encode(['status' => 'error', 'message' => 'Product_id is required']);
        exit();
    }

    // Extract and sanitize input
    $productId = $data['Product_id'];
    $productName = $data['Product_name'];
    $mrp = (float)$data['MRP'];
    $priceType = (int)$data['Price_type']; // 1 = Inclusive, 2 = Exclusive
    $taxPercentage = isset($data['Tax_percentage']) ? (float)$data['Tax_percentage'] : 5; // Default to 5%

    // Optional fields
    $purchasePrice = isset($data['Purchase_price']) ? (float)$data['Purchase_price'] : 0;
    $variant = isset($data['Variant']) ? $data['Variant'] : '';
    $productDescription = isset($data['Product_description']) ? $data['Product_description'] : '';
    $hsn = isset($data['HSN']) ? $data['HSN'] : '';
    $qty = isset($data['qty']) ? (int)$data['qty'] : 0;
    $category = isset($data['category']) ? $data['category'] : ''; // Assuming category exists
    $unit = isset($data['M_unit']) ? $data['M_unit'] : ''; // Assuming unit exists
    $productImage = isset($data['Product_image']) ? $data['Product_image'] : ''; // Assuming product image exists
    $salePriceTax = isset($data['Sale_price_tax']) ? (float)$data['Sale_price_tax'] : 0;
    $purchasePriceTax = isset($data['Purchase_price_tax']) ? (float)$data['Purchase_price_tax'] : 0;
    $shippingWeight = isset($data['Shipping_weight']) ? (float)$data['Shipping_weight'] : 0;
    $packingDate = isset($data['Packing_date']) ? $data['Packing_date'] : '';
    $expiryDate = isset($data['Expiry_date']) ? $data['Expiry_date'] : '';
    $locationRack = isset($data['Location_rack']) ? $data['Location_rack'] : '';
    $brand = isset($data['Brand']) ? $data['Brand'] : '';
    $youtubeUrl = isset($data['Youtube_url']) ? $data['Youtube_url'] : '';
    $barcode = isset($data['barcode']) ? $data['barcode'] : '';
    $minQty = isset($data['minqty']) ? (int)$data['minqty'] : 0;
    $maxQty = isset($data['maxqty']) ? (int)$data['maxqty'] : 0;
    $editId = isset($data['Edit_id']) ? $data['Edit_id'] : 0; // Assuming edit id

    // Initialize variables for calculations
    $price = 0;
    $taxValue = 0;
    $sellingPrice = 0;
    $discountValue = 0;
    $discountPercentage = 0;

    // Perform calculations based on Price_type
    if ($priceType == 1) { // Inclusive tax
        if (!isset($data['Selling_price'])) {
            echo json_encode(['status' => 'error', 'message' => 'Selling price is required for inclusive tax']);
            exit();
        }
        $sellingPrice = (float)$data['Selling_price'];
        $price = $sellingPrice / (1 + $taxPercentage / 100);
        $taxValue = $sellingPrice - $price;
    } elseif ($priceType == 2) { // Exclusive tax
        if (!isset($data['price'])) {
            echo json_encode(['status' => 'error', 'message' => 'Price is required for exclusive tax']);
            exit();
        }
        $price = (float)$data['price'];
        $taxValue = $price * $taxPercentage / 100;
        $sellingPrice = $price + $taxValue;
    }

    // Common calculations for discount
    $discountValue = $mrp - $sellingPrice;
    $discountPercentage = (($mrp - $sellingPrice) / $mrp * 100);

    // Prepare the SQL update query
    $sql = "UPDATE product SET 
                Product_name = '$productName',
                Purchase_price = '$purchasePrice',
                MRP = '$mrp',
                Selling_price = '$sellingPrice',
                price = '$price',
                category = '$category',
                Variant = '$variant',
                Product_description = '$productDescription',
                M_unit = '$unit',
                HSN = '$hsn',
                qty = '$qty',
                Price_type = '$priceType',
                Product_image = '$productImage',
                Sale_price_tax = '$salePriceTax',
                Purchase_price_tax = '$purchasePriceTax',
                Shipping_weight = '$shippingWeight',
                Tax_percentage = '$taxPercentage',
                tax = '$taxValue',
                Discount_percentage = '$discountPercentage',
                Discount_value = '$discountValue',
                Packing_date = '$packingDate',
                Expiry_date = '$expiryDate',
                Location_rack = '$locationRack',
                Brand = '$brand',
                Youtube_url = '$youtubeUrl',
                barcode = '$barcode',
                minqty = '$minQty',
                maxqty = '$maxQty',
                Edit_id = '$user_id'
            WHERE Product_id = '$productId'";

    // Execute the query
    if ($conn->query($sql) === TRUE) {
        echo json_encode(['status' => 'success', 'message' => 'Product updated successfully']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update product', 'error_detail' => $conn->error]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
}

// Close the database connection
$conn->close();
?>
